//: ## Structs
//:
//: Structs define data structures for values.
//:
//: Each structure may declare properties and functions.
//:
//: -------------------
//:
//: [◀  Previous Page](@previous)  |  [Next Page  ▶](@next)
//:
//: -------------------
//:


struct Example {
    
    // stored properties on the instance
    var storedProperty1: Int
    var storedProperty2: Double
    var storedProperty3: Bool
    var storedProperty4: String
    
    // type properties on the type
    static let typeProperty1:  Int = 1
    static let typeProperty2: Double = 2.0
    static let typeProperty3: Bool = true
    static let typeProperty4: String = "4.0"

    // initialiser
    init(storedProperty1: Int, storedProperty2: Double, storedProperty3: Bool, storedProperty4: String) {
        self.storedProperty1 = storedProperty1
        self.storedProperty2 = storedProperty2
        self.storedProperty3 = storedProperty3
        self.storedProperty4 = storedProperty4
    }
    
    // instance method
    func instanceMethod() {
        let description = """
        \(storedProperty1)
        \(storedProperty2)
        \(storedProperty3)
        \(storedProperty4)
        """
        print(description)
    }
    
    // type method
    static func typeMethod() {
        let description = """
        \(typeProperty1)
        \(typeProperty2)
        \(typeProperty3)
        \(typeProperty4)
        """
        print(description)
    }
}


//:
//: -------------------
//:
//: Instances
//:
//: -------------------
//:


// create an instance of Example
var example = Example(storedProperty1: 1, storedProperty2: 2, storedProperty3: false, storedProperty4: "four")

// stored properties
print(example.storedProperty1)
print(example.storedProperty2)
print(example.storedProperty3)
print(example.storedProperty4)
// instance methods
example.instanceMethod()




//:
//: -------------------
//:
//: Type Properties & Type Methods
//:
//: -------------------
//:


// type properties
print(Example.typeProperty1)
print(Example.typeProperty2)
print(Example.typeProperty3)
print(Example.typeProperty4)
// type methods
Example.printTypeProperties())


//:
//: -------------------
//:
//: [◀  Previous Page](@previous)  |  [Next Page  ▶](@next)
//:
//: -------------------
//:
//: ## ![3 Days Of Swift Logo](3DaysIcon146.png) 3 Days Of Swift 
//:
//: © Copyright. All rights reserved.
//:
//: 🧕🏻🙋🏽‍♂️👨🏿‍💼👩🏼‍💼👩🏻‍💻💁🏼‍♀️👨🏼‍💼🙋🏻‍♂️🙋🏻‍♀️👩🏼‍💻🙋🏿💁🏽‍♂️🙋🏽‍♀️🙋🏿‍♀️🧕🏾🙋🏼‍♂️
//:
//: Welcome to our community of [3DaysOfSwift.com](https://www.3DaysOfSwift.com) developers!
